///////////////////////////////////////////////////////////////////////////////////////
//
// MonoScan
//
// 03/05/07		Hounddog	Support for sporadic faults
// 27/04/07		Hounddog	Initial implementation
//

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using System.Text;
using System.Xml;

namespace MonoScan.MonoMotronic121
{
	public class FaultsForm : MonoScan.TextForm
	{
		private System.ComponentModel.IContainer components = null;

		public FaultsForm(Scanner scanner, XmlNode xmlNode)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			this.scanner = scanner;
			this.xmlNode = xmlNode;
		}

		protected Scanner scanner;
		protected XmlNode xmlNode;

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			// 
			// textBox
			// 
			this.textBox.HideSelection = true;
			this.textBox.Name = "textBox";
			this.textBox.Size = new System.Drawing.Size(392, 133);
			// 
			// FaultsForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(392, 133);
			this.Location = new System.Drawing.Point(10, 10);
			this.Name = "FaultsForm";
			this.Text = "Faults";

		}
		#endregion

		public void Execute()
		{
			int statusMessageId = scanner.MainForm.PushStatusMessage("Reading faults");

			try
			{
				scanner.MainForm.Update();

				MonoComm.Fault[] faults;
				MonoComm.Status status = MonoComm.GetFaults(out faults);

				if (status != MonoComm.Status.Ok)
					throw new MonoComm.Exception(status);

				if (faults.Length != 0)
				{
					MonoComm.Fault fault = faults[0];

					if (faults.Length != 1 || fault.Code != 0xFFFF || fault.SubCode != 8)
					{
						StringBuilder stringBuilder = new StringBuilder();

						for (int index = 0; index < faults.Length; ++ index)
						{
							fault = faults[index];

							stringBuilder.AppendFormat("\r\n     {0} {1} - {2}", fault.Sporadic ? "Sporadic fault" : "Fault", fault.Code, fault.SubCode);

							XmlNode faultXmlNode = Configuration.FindXmlNode(xmlNode, "Fault[@Code=\"{0}\"]", fault.Code);

							if (faultXmlNode != null)
							{
								string faultDescription = Configuration.GetXmlNodeAttribute(faultXmlNode, "Description");
								stringBuilder.AppendFormat(" : {0}", faultDescription);

								XmlNode subFaultXmlNode = Configuration.FindXmlNode(faultXmlNode, "SubFaults/SubFault[@Code=\"{0}\"]", fault.SubCode);

								if (subFaultXmlNode != null)
								{
									string subFaultDescription = Configuration.GetXmlNodeAttribute(subFaultXmlNode, "Description");
									stringBuilder.AppendFormat(" - {0}", subFaultDescription);
								}
							}
						}

						textBox.Text = stringBuilder.ToString();
					}
					else
						textBox.Text = "\r\n     No faults";
				}
				else
					textBox.Text = "\r\n     No faults";

				textBox.SelectionLength = 0;
			}
			finally
			{
				scanner.MainForm.PopStatusMessage(statusMessageId);
			}
		}
	}
}